/*
 Selectable
 Copyright (c) 2017 Karl Saunders (http://mobius.ovh)
 Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.

 Version: 0.17.2

*/
(function(y,n){"object"===typeof exports?module.exports=n("Selectable"):"function"===typeof define&&define.amd?define([],n):y.Selectable=n("Selectable")})("undefined"!==typeof global?global:this.window||this.global,function(){function y(a,c){return a&&a!==document.documentElement&&(c(a)?a:y(a.parentNode,c))}function n(a){return"[object Object]"===Object.prototype.toString.call(a)}function q(a){return Array.isArray(a)||a instanceof HTMLCollection||a instanceof NodeList}function C(a,c){for(var b in c)if(c.hasOwnProperty(b)){var d=
    c[b];d&&n(d)?(a[b]=a[b]||{},C(a[b],d)):a[b]=d}return a}function A(a,c){var b=a.style;if(a){if(void 0===c)return window.getComputedStyle(a);if(n(c))for(var d in c)d in b||(d="-webkit-"+d),a.style[d]=c[d]+("string"==typeof c[d]?"":"opacity"===d?"":"px")}}function B(a){var c=window;a=a.getBoundingClientRect();var b=document.documentElement||document.body.parentNode||document.body,d=void 0!==c.pageXOffset?c.pageXOffset:b.scrollLeft;c=void 0!==c.pageYOffset?c.pageYOffset:b.scrollTop;return{x1:a.left+d,
    x2:a.left+a.width+d,y1:a.top+c,y2:a.top+a.height+c,height:a.height,width:a.width}}function F(a,c,b){var d;return function(){b=b||this;if(!d)return a.apply(b,arguments),d=!0,setTimeout(function(){d=!1},c)}}var D="classList"in document.documentElement,h={add:function(a,c){D?a.classList.add(c):h.contains(a,c)||(a.className=a.className.trim()+" "+c)},remove:function(a,c){D?a.classList.remove(c):h.contains(a,c)&&(a.className=a.className.replace(new RegExp("(^|\\s)"+c.split(" ").join("|")+"(\\s|$)","gi"),
    " "))},contains:function(a,c){if(a)return D?a.classList.contains(c):!!a.className&&!!a.className.match(new RegExp("(\\s|^)"+c+"(\\s|$)"))}},v=function(a){return!!a.ctrlKey||!!a.metaKey},w=["x","y"],p={x:"x1",y:"y1"},u={x:"x2",y:"y2"},E=function(a){this.version="0.17.2";this.v=this.version.split(".").map(function(a){return parseInt(a,10)});this.touch="ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch;this.init(a)};E.prototype={init:function(a){var c=this,b=this;this.config=
    C({filter:".ui-selectable",tolerance:"touch",appendTo:document.body,toggle:!1,autoRefresh:!0,throttle:50,lassoSelect:"normal",autoScroll:{threshold:0,increment:10},saveState:!1,ignore:!1,maxSelectable:!1,lasso:{border:"1px dotted #000",backgroundColor:"rgba(52, 152, 219, 0.2)"},keys:["shiftKey","ctrlKey","metaKey",""],classes:{lasso:"ui-lasso",selected:"ui-selected",container:"ui-container",selecting:"ui-selecting",selectable:"ui-selectable",deselecting:"ui-deselecting"}},a);this.origin={x:0,y:0};
    this.mouse={x:0,y:0};var d=this.config;this.autoscroll=n(d.autoScroll);this.lasso=!1;d.lasso&&n(d.lasso)&&(this.lasso=document.createElement("div"),this.lasso.className=d.classes.lasso,A(this.lasso,C({position:"absolute",boxSizing:"border-box",opacity:0},d.lasso)));this.touch&&(d.toggle=!1);this.events={};"_start _touchstart _drag _end _keyup _keydown _blur _focus".split(" ").forEach(function(a){c.events[a]=c[a].bind(c)});this.events._refresh=F(this.refresh,d.throttle,this);this.autoscroll&&(this.events._scroll=
    this._onScroll.bind(this));this.setContainer();this.scroll={x:this.bodyContainer?window.pageXOffset:this.container.scrollLeft,y:this.bodyContainer?window.pageYOffset:this.container.scrollTop};q(d.filter)?this.nodes=[].slice.call(d.filter):"string"===typeof d.filter&&(this.nodes=[].slice.call(this.container.querySelectorAll(d.filter)));this.nodes.forEach(function(a){h.add(a,d.classes.selectable)});this.update();this.enable();setTimeout(function(){d.saveState&&b.state("save");b.emit(15>b.v[1]?"selectable.init":
    "init")},10)},update:function(){this._loadItems();this.refresh();this.emit(15>this.v[1]?"selectable.update":"update",this.items)},refresh:function(){var a=window.innerWidth,c=window.innerHeight,b=this.bodyContainer?window.pageXOffset:this.container.scrollLeft,d=this.bodyContainer?window.pageYOffset:this.container.scrollTop;this.offsetWidth=this.container.offsetWidth;this.offsetHeight=this.container.offsetHeight;this.clientWidth=this.container.clientWidth;this.clientHeight=this.container.clientHeight;
    this.scrollWidth=this.container.scrollWidth;this.scrollHeight=this.container.scrollHeight;this.boundingRect=B(this.container);this.bodyContainer&&(this.boundingRect.x2=a,this.boundingRect.y2=c);this.scroll={x:b,y:d,max:{x:this.scrollWidth-(this.bodyContainer?a:this.clientWidth),y:this.scrollHeight-(this.bodyContainer?c:this.clientHeight)},size:{x:this.clientWidth,y:this.clientHeight},scrollable:{x:this.scrollWidth>this.offsetWidth,y:this.scrollHeight>this.offsetHeight}};for(a=0;a<this.nodes.length;a++)this.items[a].rect=
    B(this.nodes[a]);this.emit(15>this.v[1]?"selectable.refresh":"refresh")},bind:function(){var a=this.events;this.unbind();if(this.touch){if(this.on(this.container,"touchstart",a._touchstart),this.on(document,"touchend",a._end),this.on(document,"touchcancel",a._end),!1!==this.lasso)this.on(document,"touchmove",a._drag)}else if(this.on(this.container,"mousedown",a._start),this.on(document,"mouseup",a._end),this.on(document,"keydown",a._keydown),this.on(document,"keyup",a._keyup),this.on(this.container,
    "mouseenter",a._focus),this.on(this.container,"mouseleave",a._blur),!1!==this.lasso)this.on(document,"mousemove",a._drag);if(this.autoscroll)this.on(this.bodyContainer?window:this.container,"scroll",a._scroll);this.on(window,"resize",a._refresh);this.on(window,"scroll",a._refresh)},unbind:function(){var a=this.events;this.off(this.container,"mousedown",a._start);this.off(document,"mousemove",a._drag);this.off(document,"mouseup",a._end);this.off(document,"keydown",a._keydown);this.off(document,"keyup",
    a._keyup);this.off(this.container,"mouseenter",a._focus);this.off(this.container,"mouseleave",a._blur);this.autoscroll&&this.off(this.bodyContainer?window:this.container,"scroll",a._scroll);this.off(this.container,"touchstart",a._start);this.off(document,"touchend",a._end);this.off(document,"touchcancel",a._end);this.off(document,"touchmove",a._drag);this.off(window,"resize",a._refresh);this.off(window,"scroll",a._refresh)},setContainer:function(a){var c=this.config;if(this.container){var b=this.container;
    this.unbind()}a=a||c.appendTo;"string"===typeof a?this.container=document.querySelector(a):a instanceof Element&&a.nodeName&&(this.container=a);h.add(this.container,c.classes.container);b&&h.remove(b,c.classes.container);this.bodyContainer=this.container===document.body;this._loadItems();this.autoscroll&&"static"===A(this.container).position&&!this.bodyContainer&&(this.container.style.position="relative");this.bind()},select:function(a,c){if(q(a)){for(var b=this.getSelectedItems().length,d=0;d<a.length&&
    !(this.config.maxSelectable&&b>=this.config.maxSelectable);d++)this.select(a[d]),b++;return this.getSelectedItems()}if(a=this.get(a)){if(this.config.toggle&&"drag"===this.config.toggle&&!c&&a.selected&&!this.cmdDown)return this.deselect(a);b=a.node;d=this.config.classes;h.remove(b,d.selecting);h.add(b,d.selected);a.selecting=!1;a.selected=!0;a.startselected=!0;this.emit(15>this.v[1]?"selectable.select":"selecteditem",a);return a}return!1},deselect:function(a){if(q(a)){for(var c=0;c<a.length;c++)this.deselect(a[c]);
    return this.getSelectedItems()}if(a=this.get(a)){c=a.node;var b=this.config.classes;a.selecting=!1;a.selected=!1;a.deselecting=!1;a.startselected=!1;h.remove(c,b.deselecting);h.remove(c,b.selecting);h.remove(c,b.selected);this.emit(15>this.v[1]?"selectable.deselect":"deselecteditem",a);return a}return!1},toggle:function(a){if(a=this.get(a)){q(a)||(a=[a]);for(var c=0;c<a.length;c++)a[c].selected?this.deselect(a[c]):this.select(a[c])}},add:function(a){var c=[];"string"===typeof a&&(a=[].slice.call(this.container.querySelectorAll(a)));
    q(a)||(a=[a]);for(var b=0;b<a.length;b++)0>this.nodes.indexOf(a[b])&&a[b]instanceof Element&&(c.push(a[b]),h.add(a[b],this.config.classes.selectable));this.nodes=this.nodes.concat(c);this.update();for(b=0;b<c.length;b++)this.emit("addeditem",this.get(c[b]))},remove:function(a,c){if(a=this.get(a)){if(q(a))for(var b=a.length-1;0<=b;b--)this.remove(a[b],0<b);else{b=a.node;var d=this.config.classes,e=h.remove;e(b,d.selectable);e(b,d.deselecting);e(b,d.selecting);e(b,d.selected);this.nodes.splice(this.nodes.indexOf(a.node),
    1);this.emit("removeditem",a)}c||this.update();return!0}return!1},selectAll:function(){if(this.config.maxSelectable&&this.config.maxSelectable<this.items.length)return this._maxReached();for(var a=0;a<this.items.length;a++)this.select(this.items[a],!0)},invert:function(){var a=this.getItems();if(this.config.maxSelectable&&this.config.maxSelectable<a.length)return this._maxReached();for(a=0;a<this.items.length;a++){var c=this.items[a];c.selected?this.deselect(c):this.select(c)}},clear:function(){for(var a=
    this.items.length-1;0<=a;a--)this.deselect(this.items[a])},get:function(a){var c=!1;"string"===typeof a&&(a=[].slice.call(this.container.querySelectorAll(a)));if(q(a)){c=[];for(var b=0;b<a.length;b++){var d=this.get(a[b]);d&&c.push(d)}}else isNaN(a)?a instanceof Element?c=this.items[this.nodes.indexOf(a)]:n(a)&&0<=this.items.indexOf(a)&&(c=a):0<=this.items.indexOf(this.items[a])&&(c=this.items[a]);return c},getItems:function(){return this.items},getNodes:function(){return this.nodes},getSelectedItems:function(a){return this.getItems().filter(function(c){return a?
    !c.selected:c.selected})},getSelectedNodes:function(){return this.getSelectedItems().map(function(a){return a.node})},state:function(a){var c=!1,b=!1;switch(a){case "save":this.states=this.states||[];this.states.push(this.getSelectedNodes());b=this.config.saveState;b="isInteger"in Number?Number.isInteger(b):!isNaN(b);b&&this.states.length>this.config.saveState&&this.states.shift();this.currentState=this.states.length-1;b=!0;break;case "undo":0<this.currentState&&(this.currentState--,b=c=!0);break;
    case "redo":this.currentState<this.states.length-1&&(this.currentState++,b=c=!0);break;case "clear":this.states=[],this.currentState=!1}c&&(this.clear(),this.select(this.states[this.currentState]));b&&this.emit((15>this.v[1]?"selectable.state.":"state.")+a,this.states[this.currentState],this.states)},enable:function(){if(!this.enabled){var a=this.config.keys;this.enabled=!0;this.canShift=0<=a.indexOf("shiftKey");this.canCtrl=0<=a.indexOf("ctrlKey");this.canMeta=0<=a.indexOf("metaKey");this.bind();
    h.add(this.container,this.config.classes.container);this.emit(15>this.v[1]?"selectable.enable":"enabled")}return this.enabled},disable:function(){this.enabled&&(this.enabled=!1,this.unbind(),h.remove(this.container,this.config.classes.container),this.emit(15>this.v[1]?"selectable.disable":"disabled"));return this.enabled},destroy:function(){this.disable();this.listeners=!1;this.clear();this.state("clear");this.remove(this.items)},on:function(a,c,b){"string"===typeof a?(this.listeners=this.listeners||
    {},this.listeners[a]=this.listeners[a]||[],this.listeners[a].push(c)):a.addEventListener(c,b,!1)},off:function(a,c,b){"string"===typeof a?(this.listeners=this.listeners||{},!1!==a in this.listeners&&this.listeners[a].splice(this.listeners[a].indexOf(c),1)):a.removeEventListener(c,b)},emit:function(a){this.listeners=this.listeners||{};if(!1!==a in this.listeners)for(var c=0;c<this.listeners[a].length;c++)this.listeners[a][c].apply(this,Array.prototype.slice.call(arguments,1))},_maxReached:function(){return this.emit("maxitems")},
    _touchstart:function(a){this.off(this.container,"mousedown",this.events.start);this._start(a)},_start:function(a){var c=this,b=this._getEvent(a),d=this.config,e,l=v(a)&&(this.canCtrl||this.canMeta),m=this.canShift&&!!a.shiftKey,k=this.getSelectedItems().length,g=d.maxSelectable;if(g&&k>=g&&(l||m||d.toggle))return this._maxReached();if(!(!this.container.contains(a.target)||3===a.which||0<a.button||d.disabled)){if(this.scroll.scrollable.y&&b.pageX>this.boundingRect.x1+this.scroll.size.x||this.scroll.scrollable.x&&
    b.pageY>this.boundingRect.y1+this.scroll.size.y)return!1;if(this.config.ignore){k=!1;var f=this.config.ignore;Array.isArray(f)||(f=[f]);for(g=0;g<f.length;g++)if(a.target.closest(f[g])){k=!0;break}if(k)return!1}k=y(a.target,function(a){return a===c.container||h.contains(a,d.classes.selectable)});if(!k)return!1;-1===["INPUT","SELECT","BUTTON","TEXTAREA","OPTION"].indexOf(a.target.tagName)&&a.preventDefault();this.dragging=!0;this.origin={x:b.pageX+(this.bodyContainer?0:this.scroll.x),y:b.pageY+(this.bodyContainer?
    0:this.scroll.y),scroll:{x:this.scroll.x,y:this.scroll.y}};this.lasso&&this.container.appendChild(this.lasso);k!==this.container&&(b=this.get(k),b.selecting=!0,h.add(k,d.classes.selecting));d.autoRefresh&&this.refresh();if(m&&this.startEl){g=this.items;b=this.getNodes().indexOf(k);f=this.getNodes().indexOf(this.startEl);for(var r=b<f?1:-1;(b+=r)&&b!==f;)g[b].selecting=!0}for(g=0;g<this.items.length;g++)b=this.items[g],f=b.node,r=f===k,b.selected&&(b.startselected=!0,(this.touch||d.toggle||l?!r:r||
    m)||(h.remove(f,d.classes.selected),b.selected=!1,h.add(f,d.classes.deselecting),b.deselecting=!0)),r&&(e=b);this.startEl=k;this.emit(15>this.v[1]?"selectable.start":"start",a,e)}},_drag:function(a){var c=this.config;if(!(c.disabled||!this.dragging||a.shiftKey&&this.canShift)){var b=this._getEvent(a);v(a);this.mouse={x:b.pageX,y:b.pageY};this.current={x1:this.origin.x,y1:this.origin.y,x2:this.mouse.x+(this.bodyContainer?0:this.scroll.x),y2:this.mouse.y+(this.bodyContainer?0:this.scroll.y)};for(var d=
    0;d<w.length;d++){var e=w[d];if(this.current[p[e]]>this.current[u[e]]){var h=this.current[u[e]];this.current[u[e]]=this.current[p[e]];this.current[p[e]]=h}}this.coords={x1:this.current.x1,x2:this.current.x2-this.current.x1,y1:this.current.y1,y2:this.current.y2-this.current.y1};if("normal"===c.lassoSelect)for(d=0;d<this.items.length;d++)this._highlight(this.items[d],v(a)&&(this.canCtrl||this.canMeta),b);else"sequential"===c.lassoSelect&&this._sequentialSelect(b);this.autoscroll&&(this.bodyContainer||
    (this.coords.x1-=this.boundingRect.x1,this.coords.y1-=this.boundingRect.y1),this._autoScroll());this.lasso&&(this.bodyContainer||!this.autoscroll||this.config.autoScroll.lassoOverflow||this._limitLasso(),A(this.lasso,{left:this.coords.x1,top:this.coords.y1,width:this.coords.x2,height:this.coords.y2,opacity:1}));this.emit(15>this.v[1]?"selectable.drag":"drag",a,this.coords)}},_end:function(a){if(this.dragging){this.dragging=!1;var c=this.config,b=a.target,d=this._getEvent(a),e=[],l=[],m=this.getSelectedItems().length,
    k=c.maxSelectable;this.lasso&&this.container.contains(this.lasso)&&this.container.removeChild(this.lasso);this.lasso&&(A(this.lasso,{opacity:0,left:0,width:0,top:0,height:0}),b=document.elementFromPoint(d.pageX,d.pageY),b||(b=this.container));b=y(b,function(a){return h.contains(a,c.classes.selectable)});d=!1;for(var g=0;g<this.items.length;g++){var f=this.items[g];c.toggle&&f.node===b&&f.node===this.startEl&&f.selecting&&f.startselected&&(f.deselecting=!0,f.selecting=!1);f.deselecting&&(l.push(f),
    this.deselect(f));f.selecting&&(k&&m+e.length>=k?(f.selecting=!1,h.remove(f.node,c.classes.selecting),d=!0):(e.push(f),this.select(f)))}c.saveState&&this.state("save");this.emit(15>this.v[1]?"selectable.end":"end",a,e,l);if(d)return this._maxReached()}},_keydown:function(a){this.cmdDown=v(a)&&(this.canCtrl||this.canMeta);var c=!1;void 0!==a.key?c=a.key:void 0!==a.keyCode&&(c=a.keyCode);if(c)if(this.cmdDown&&this.focused)switch(c){case 65:case "a":case "A":this.selectAll();break;case 89:case "y":case "Y":this.state("redo");
    break;case 90:case "z":case "Z":this.state("undo")}else switch(c){case 32:case " ":this.toggle(document.activeElement)}},_keyup:function(a){this.cmdDown=v(a)&&(this.canCtrl||this.canMeta)},_onScroll:function(a){this.scroll.x=this.bodyContainer?window.pageXOffset:this.container.scrollLeft;this.scroll.y=this.bodyContainer?window.pageYOffset:this.container.scrollTop;for(a=0;a<this.items.length;a++)this.items[a].rect=B(this.items[a].node)},_loadItems:function(){var a=this.config;this.nodes=[].slice.call(this.container.querySelectorAll("."+
    a.classes.selectable));this.items=[];if(this.nodes.length)for(var c=0;c<this.nodes.length;c++){var b=this.nodes[c];h.add(b,a.classes.selectable);var d={node:b,rect:B(b),startselected:!1,selected:h.contains(b,a.classes.selected),selecting:h.contains(b,a.classes.selecting),deselecting:h.contains(b,a.classes.deselecting)},e=this._get2DTransformation(b);if(e){var l=b;var m=0;var k=0;do m+=l.offsetTop||0,k+=l.offsetLeft||0,l=l.offsetParent;while(l);l=m;m=e.origin;var g=e.scale,f=b.offsetWidth,r=b.offsetHeight;
    b=k;k=parseInt(m[0],10);m=parseInt(m[1],10);var x=f/2,z=r/2;f=b+(x-k)*g+k;r=l+(z-m)*g+m;x*=g;g*=z;g=[{x:f-x,y:r-g},{x:f+x,y:r-g},{x:f+x,y:r+g},{x:f-x,y:r+g}];for(f=0;3>=f;f++){r=g;x=f;z=g[f].x;var p=g[f].y,n=b+k,q=l+m,t=e.angle;t=t*Math.PI/180;r[x]={x:Math.cos(t)*(z-n)-Math.sin(t)*(p-q)+n,y:Math.sin(t)*(z-n)+Math.cos(t)*(p-q)+q}}d.transform={rect:g}}this.items.push(d)}},_getEvent:function(a){return this.touch?"touchend"===a.type?a.changedTouches[0]:a.touches[0]:a},_autoScroll:function(){var a=this.config.autoScroll,
    c=a.increment;a=a.threshold;var b={x:0,y:0};this.bodyContainer&&(this.mouse.x-=this.scroll.x,this.mouse.y-=this.scroll.y);for(var d=0;d<w.length;d++){var e=w[d];this.mouse[e]>=this.boundingRect[u[e]]-a&&this.scroll[e]<this.scroll.max[e]?b[e]=c:this.mouse[e]<=this.boundingRect[p[e]]+a&&0<this.scroll[e]&&(b[e]=-c)}this.bodyContainer?window.scrollBy(b.x,b.y):(this.container.scrollTop+=b.y,this.container.scrollLeft+=b.x)},_limitLasso:function(){for(var a=0;a<w.length;a++){var c=w[a],b=this.boundingRect[p[c]]+
    this.scroll.size[c];if(this.mouse[c]>=b&&this.scroll[c]>=this.scroll.max[c]){var d=this.origin[c]-this.boundingRect[p[c]]-this.scroll[c];this.coords[p[c]]=this.origin[c]-this.boundingRect[p[c]];this.coords[u[c]]=b-d-this.boundingRect[p[c]]}this.mouse[c]<=this.boundingRect[p[c]]&&0>=this.scroll[c]&&(this.coords[p[c]]=0,this.coords[u[c]]=this.origin[c]-this.boundingRect[p[c]])}},_sequentialSelect:function(a){var c=this.config.classes,b=document.elementFromPoint(a.pageX,a.pageY-window.pageYOffset);if(b&&
    (b=b.closest("."+c.selectable))){if(this.mouse.y>this.origin.y){var d=this.nodes.indexOf(this.startEl);var e=this.nodes.indexOf(b)}else this.mouse.y<this.origin.y&&(d=this.nodes.indexOf(b),e=this.nodes.indexOf(this.startEl));for(b=0;b<this.items.length;b++){var h=this.items[b];b>=d&&b<=e?this._highlight(h,v(a)&&(this.canCtrl||this.canMeta)):(h.selecting=!1,h.node.classList.remove(c.selecting))}}},_highlight:function(a,c,b){b=this.config;var d=a.node,e=!1,l=this.bodyContainer?0:this.scroll.x,m=this.bodyContainer?
    0:this.scroll.y;if("normal"===b.lassoSelect)if("touch"===b.tolerance)if(a.transform)a:{e=[{x:this.origin.x,y:this.origin.y},{x:this.mouse.x+l,y:this.origin.y},{x:this.mouse.x+l,y:this.mouse.y+m},{x:this.origin.x,y:this.mouse.y+m}],l=a.transform.rect;var k,g,f,r=[e,l];for(m=0;m<r.length;m++){var p=r[m];for(k=0;k<p.length;k++){var n=p[k];var q=p[(k+1)%p.length];var v=q.y-n.y,w=n.x-q.x;n=q=void 0;for(g=0;g<e.length;g++){var t=v*e[g].x+w*e[g].y;(void 0===n||t<n)&&(n=t);(void 0===q||q<t)&&(q=t)}var u=
    f=void 0;for(g=0;g<l.length;g++)t=v*l[g].x+w*l[g].y,(void 0===u||t<u)&&(u=t),(void 0===f||f<t)&&(f=t);if(q<u||f<n){e=!1;break a}}}e=!0}else e=!(a.rect.x1+l>this.current.x2||a.rect.x2+l<this.current.x1||a.rect.y1+m>this.current.y2||a.rect.y2+m<this.current.y1);else"fit"===b.tolerance&&(e=a.rect.x1+l>this.current.x1&&a.rect.x2+l<this.current.x2&&a.rect.y1+m>this.current.y1&&a.rect.y2+m<this.current.y2);else e=!0;e?(a.selected&&!b.toggle&&(h.remove(d,b.classes.selected),a.selected=!1),a.deselecting&&
    (!b.toggle||b.toggle&&"drag"!==b.toggle)&&(h.remove(d,b.classes.deselecting),a.deselecting=!1),a.selecting||(h.add(d,b.classes.selecting),a.selecting=!0)):(a.selecting&&(h.remove(d,b.classes.selecting),a.selecting=!1,c&&a.startselected?(h.add(d,b.classes.selected),a.selected=!0):a.startselected&&!b.toggle&&(h.add(d,b.classes.deselecting),a.deselecting=!0)),!d.selected||c||a.startselected||(h.remove(d,b.classes.selected),a.selected=!1,h.add(d,b.classes.deselecting),a.deselecting=!0))},_focus:function(a){this.focused=
    !0;h.add(this.container,"ui-focused")},_blur:function(a){this.focused=!1;h.remove(this.container,"ui-focused")},_get2DTransformation:function(a){a=window.getComputedStyle(a,null);var c=a.getPropertyValue("-webkit-transform")||a.getPropertyValue("-moz-transform")||a.getPropertyValue("-ms-transform")||a.getPropertyValue("-o-transform")||a.getPropertyValue("transform")||!1;if(c&&"none"!==c){var b=c.split("(")[1].split(")")[0].split(", ");c=parseFloat(b[0]);b=parseFloat(b[1]);return{angle:Math.round(180/
    Math.PI*Math.atan2(b,c)),scale:Math.sqrt(c*c+b*b),origin:a.transformOrigin.split(" ")}}return!1}};return E});